VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Fetch"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'------------------------------------------------------------------
' Name : Fetch
'
' Purpose : Purpose an interface to read the data by group of 25
'
' Method:
'   1) Initialize   Change value of main variable
'   2) ExecuteQry   - Execute the request
'                   - Determine the column number and type
'                   - Create the appropriate buffers (may be
'                     special buffer for Extended Fetch method)
'                   - Declare the buffer to ODBC Driver for the
'                     Extended Fetch Method
'   3) FillMore     - Read the 25 next rows
'                   - Destruct the statement if one problem occurs
'                     or if there is no more data
'   4) GetData      - Read one data in the memory
'                   - If one problem occurs, return ""
'   5) Terminate    - Close the statement if necessary
'                   - Destruct the buffers
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------

' Number of data per buffer
Const NB_MAX_DATA = 25

' Type Buffer Constants
Const BUF_INTEGER    As Integer = 1
Const BUF_LONG       As Integer = 2
Const BUF_REAL       As Integer = 3
Const BUF_DOUBLE     As Integer = 4
Const BUF_STRING5    As Integer = 5
Const BUF_STRING20   As Integer = 6
Const BUF_STRING80   As Integer = 7
Const BUF_STRING120  As Integer = 8
Const BUF_STRING200  As Integer = 9
Const BUF_STRING255  As Integer = 10
Const BUF_STRING500  As Integer = 11
Const BUF_STRING1000 As Integer = 12

' Declare of the Byte Array to stock the Extended Fetch string
Private Type StringB5
    Value(5) As Byte
End Type

Private Type StringB20
    Value(20) As Byte
End Type

Private Type StringB80
    Value(80) As Byte
End Type

Private Type StringB120
    Value(120) As Byte
End Type

Private Type StringB200
    Value(200) As Byte
End Type

Private Type StringB255
    Value(255) As Byte
End Type

Private Type StringB500
    Value(500) As Byte
End Type

Private Type StringB1000
    Value(1000) As Byte
End Type

' Declare types of different buffers
Private Type TypeInteger
    Data(NB_MAX_DATA) As Integer
End Type
Private Type TypeLong
    Data(NB_MAX_DATA) As Long
End Type
Private Type TypeReal
    Data(NB_MAX_DATA) As Single
End Type
Private Type TypeDouble
    Data(NB_MAX_DATA) As Double
End Type
' Declare string type for the Extended Fetch method
Private Type TypeStringB5
    Data(NB_MAX_DATA) As StringB5
End Type
Private Type TypeStringB20
    Data(NB_MAX_DATA) As StringB20
End Type
Private Type TypeStringB80
    Data(NB_MAX_DATA) As StringB80
End Type
Private Type TypeStringB120
    Data(NB_MAX_DATA) As StringB120
End Type
Private Type TypeStringB200
    Data(NB_MAX_DATA) As StringB200
End Type
Private Type TypeStringB255
    Data(NB_MAX_DATA) As StringB255
End Type
Private Type TypeStringB500
    Data(NB_MAX_DATA) As StringB500
End Type
Private Type TypeStringB1000
    Data(NB_MAX_DATA) As StringB1000
End Type
' Declare string type for the classic method
Private Type TypeString5
    Data(NB_MAX_DATA) As String * 5
End Type
Private Type TypeString20
    Data(NB_MAX_DATA) As String * 20
End Type
Private Type TypeString80
    Data(NB_MAX_DATA) As String * 80
End Type
Private Type TypeString120
    Data(NB_MAX_DATA) As String * 120
End Type
Private Type TypeString200
    Data(NB_MAX_DATA) As String * 200
End Type
Private Type TypeString255
    Data(NB_MAX_DATA) As String * 255
End Type
Private Type TypeString500
    Data(NB_MAX_DATA) As String * 500
End Type
Private Type TypeString1000
    Data(NB_MAX_DATA) As String * 1000
End Type

' Number of each buffer
' The number of string buffer is the same for the classic or Extended Fetch method
Dim mi_NbBufferInteger    As Integer
Dim mi_NbBufferLong       As Integer
Dim mi_NbBufferReal       As Integer
Dim mi_NbBufferDouble     As Integer
Dim mi_NbBufferString5    As Integer
Dim mi_NbBufferString20   As Integer
Dim mi_NbBufferString80   As Integer
Dim mi_NbBufferString120  As Integer
Dim mi_NbBufferString200  As Integer
Dim mi_NbBufferString255  As Integer
Dim mi_NbBufferString500  As Integer
Dim mi_NbBufferString1000 As Integer

'total number of each buffer
Dim mi_NbTotBufferInteger    As Integer
Dim mi_NbTotBufferLong       As Integer
Dim mi_NbTotBufferReal       As Integer
Dim mi_NbTotBufferDouble     As Integer
Dim mi_NbTotBufferString5    As Integer
Dim mi_NbTotBufferString20   As Integer
Dim mi_NbTotBufferString80   As Integer
Dim mi_NbTotBufferString120  As Integer
Dim mi_NbTotBufferString200  As Integer
Dim mi_NbTotBufferString255  As Integer
Dim mi_NbTotBufferString500  As Integer
Dim mi_NbTotBufferString1000 As Integer

' Declare the buffers for the numeric types
Dim m_BufferInteger()    As TypeInteger
Dim m_BufferLong()       As TypeLong
Dim m_BufferReal()       As TypeReal
Dim m_BufferDouble()     As TypeDouble

' Declare the string buffers for the Extended Fetch method
Dim m_BufferStringB5()    As TypeStringB5
Dim m_BufferStringB20()   As TypeStringB20
Dim m_BufferStringB80()   As TypeStringB80
Dim m_BufferStringB120()  As TypeStringB120
Dim m_BufferStringB200()  As TypeStringB200
Dim m_BufferStringB255()  As TypeStringB255
Dim m_BufferStringB500()  As TypeStringB500
Dim m_BufferStringB1000() As TypeStringB1000

' Declare the string buffers for the classic method
Dim m_BufferString5()    As TypeString5
Dim m_BufferString20()   As TypeString20
Dim m_BufferString80()   As TypeString80
Dim m_BufferString120()  As TypeString120
Dim m_BufferString200()  As TypeString200
Dim m_BufferString255()  As TypeString255
Dim m_BufferString500()  As TypeString500
Dim m_BufferString1000() As TypeString1000

' Declare type for the buffer list
Private Type TypeDescBuffer
    Type As Integer
    Position As Integer
End Type

'Declare Type for the column description
Private Type TypeColumnDescription
    ColumnName As String * 20
    Datatype As Integer
    SizeColName As Integer
    SizeColumn As Long
    Scale As Integer
    Nullable As Integer
End Type

' Number of used buffer at a moment
Dim mi_NbBuffer As Integer
' Type and position of each buffer
Dim m_Buffers() As TypeDescBuffer
' Description of columns
Dim m_DescColumns() As TypeColumnDescription

' Declare a new type for the size of each data
Private Type TypeNbData
    Data(NB_MAX_DATA) As Long
End Type

'Indicates the Environment identifier
Dim ml_Environment As Long

'Indicates the database identifier
Dim ml_Database As Long

' Indicate the statement identifier
Dim ml_Hstmt As Long

'Indicates if we use the new NCS method of ODBC or Not
Dim mb_Use_NCS_ODBC As Boolean

' Indicate if the statement have been create
' OK : There is no statement
' KO : There is one statement
Dim mb_FreeStmt As Boolean

' Indicate if data is present in buffer
' OK : Data is present
Dim mb_DataPresent As Boolean

' Indicate if we can use Extended Fetch
' OK : we use the Extended Fetch method
Dim mb_ExtendedFetch As Boolean

' Number of data in each buffer
Dim m_NbData() As TypeNbData

' Status of each row
' SQL_SUCCESS or other value possible
Dim m_RowStatus(NB_MAX_DATA) As Integer

'------------------------------------------------------------------
' Name : DatabaseIdentifier
'
' Purpose : Must be used to indicates the database identifier
'
' Parameters :
'       ll_Database     Database identifier
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Public Property Get DatabaseIdentifier() As Long
    DatabaseIdentifier = ml_Database
End Property

Public Property Let DatabaseIdentifier(ll_Database As Long)
    ml_Database = ll_Database
End Property

'------------------------------------------------------------------
' Name : EnvironmentIdentifier
'
' Purpose : Must be used to indicate the environment identifier
'
' Parameters :
'       ll_Environment  Environment identifier
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Public Property Get EnvironmentIdentifier() As Long
    EnvironmentIdentifier = ml_Environment
End Property

Public Property Let EnvironmentIdentifier(ll_Environment As Long)
    ml_Environment = ll_Environment
End Property

'------------------------------------------------------------------
' Name : Use_NCS_ODBC
'
' Purpose : Must be used to indicate the NCS_ODBC Method. Doesn't
'           use Database and Environment Identifier
'
' Parameters :
'       lb_Use_NCS_ODBC  Use or Not NCS_ODBC Method
'
' review : 04/04/2001 by AD
'------------------------------------------------------------------
Public Property Get Use_NCS_ODBC() As Boolean
    Use_NCS_ODBC = mb_Use_NCS_ODBC
End Property

Public Property Let Use_NCS_ODBC(lb_Use_NCS_ODBC As Boolean)
    mb_Use_NCS_ODBC = lb_Use_NCS_ODBC
End Property

Private Function BindCol() As Boolean
'------------------------------------------------------------------
' Name : BindCol
'
' Purpose : Indicates to ODBC Driver the buffers to use for each
'           column
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Dim li_Status As Long
Dim l_type As Integer
Dim i As Integer
Dim li_Position As Integer

' Buffer

    On Error GoTo ErrorManager

    ' By default, the function success
    BindCol = OK
    
    For i = 1 To mi_NbBuffer
        
        ' Initialize the status of reading
        li_Status = 0
        
        ' Read the real position of the column in his buffer type
        li_Position = m_Buffers(i - 1).Position - 1
    
        ' Select the type of buffer to bind
        Select Case m_Buffers(i - 1).Type
               
            Case BUF_STRING5
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB5(li_Position).Data(0), 6, m_NbData(i - 1).Data(0))
                
            Case BUF_STRING20
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB20(li_Position).Data(0).Value(0), 21, m_NbData(i - 1).Data(0))
                
            Case BUF_STRING80
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB80(li_Position).Data(0).Value(0), 81, m_NbData(i - 1).Data(0))
                
            Case BUF_STRING120
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB120(li_Position).Data(0).Value(0), 121, m_NbData(i - 1).Data(0))
                
            Case BUF_STRING200
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB200(li_Position).Data(0).Value(0), 201, m_NbData(i - 1).Data(0))
            
            Case BUF_STRING255
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB255(li_Position).Data(0).Value(0), 256, m_NbData(i - 1).Data(0))
            
            Case BUF_STRING500
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB500(li_Position).Data(0).Value(0), 501, m_NbData(i - 1).Data(0))
            
            Case BUF_STRING1000
                ' Indicate the new column and buffer to ODBC driver
                ' We use the string buffer for the Extended Fetch method
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_CHAR, m_BufferStringB1000(li_Position).Data(0).Value(0), 1001, m_NbData(i - 1).Data(0))
               
            Case BUF_INTEGER
                ' Indicate the new column and buffer to ODBC driver
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_INTEGER, m_BufferInteger(li_Position).Data(0), 0, m_NbData(i - 1).Data(0))
                
            Case BUF_LONG
                ' Indicate the new column and buffer to ODBC driver
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_LONG, m_BufferLong(li_Position).Data(0), 0, m_NbData(i - 1).Data(0))
                
            Case BUF_REAL
                ' Indicate the new column and buffer to ODBC driver
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_REAL, m_BufferReal(li_Position).Data(0), 0, m_NbData(i - 1).Data(0))

            Case BUF_DOUBLE
                ' Indicate the new column and buffer to ODBC driver
                li_Status = SQLBindCol(ml_Hstmt, i, SQL_VB_DOUBLE, m_BufferDouble(li_Position).Data(0), 0, m_NbData(i - 1).Data(0))

        End Select
        
        ' If the status is'nt a success, the function fails
        If li_Status <> SQL_SUCCESS Then
            BindCol = KO
            Exit Function
        End If
    Next
    
    ' Return the status of this function
    Exit Function
       
ErrorManager:
    ' There was an error, the function fails
    BindCol = KO
    StdError

End Function

Private Sub ReadColumnDescription()
'------------------------------------------------------------------
' Name : ReadColumnDescription
'
' Purpose : Read the information of each column (size and type are the most important)
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Dim i As Integer

    ' Resize the description buffer
    ReDim m_DescColumns(mi_NbBuffer)
           
    ' Read the description of each column
    For i = 1 To mi_NbBuffer
    
        ' Read the description of the current column
        SQLDescribeCol ml_Hstmt, i, m_DescColumns(i - 1).ColumnName, 20, m_DescColumns(i - 1).SizeColName, m_DescColumns(i - 1).Datatype, m_DescColumns(i - 1).SizeColumn, m_DescColumns(i - 1).Scale, m_DescColumns(i - 1).Nullable
    
        ' select the type of data to choice and count the type of different buffer
        Select Case m_DescColumns(i - 1).Datatype
            
            Case SQL_NUMERIC ' VB String
                m_Buffers(i - 1).Type = BUF_STRING20
                mi_NbTotBufferString20 = mi_NbTotBufferString20 + 1
        
                mi_NbBufferString20 = mi_NbBufferString20 + 1
                m_Buffers(i - 1).Position = mi_NbBufferString20
            
            Case SQL_DECIMAL ' VB String
                m_Buffers(i - 1).Type = BUF_STRING20
                mi_NbTotBufferString20 = mi_NbTotBufferString20 + 1
            
                mi_NbBufferString20 = mi_NbBufferString20 + 1
                m_Buffers(i - 1).Position = mi_NbBufferString20
            
            Case SQL_INTEGER ' VB Long
                m_Buffers(i - 1).Type = BUF_LONG
                mi_NbTotBufferLong = mi_NbTotBufferLong + 1
                
                mi_NbBufferLong = mi_NbBufferLong + 1
                m_Buffers(i - 1).Position = mi_NbBufferLong
            
            Case SQL_SMALLINT ' VB Integer
                m_Buffers(i - 1).Type = BUF_INTEGER
                mi_NbTotBufferInteger = mi_NbTotBufferInteger + 1
            
                mi_NbBufferInteger = mi_NbBufferInteger + 1
                m_Buffers(i - 1).Position = mi_NbBufferInteger
                
            Case SQL_FLOAT ' VB Double
                m_Buffers(i - 1).Type = BUF_DOUBLE
                mi_NbTotBufferDouble = mi_NbTotBufferDouble + 1
            
                mi_NbBufferDouble = mi_NbBufferDouble + 1
                m_Buffers(i - 1).Position = mi_NbBufferDouble
                
            Case SQL_DOUBLE ' VB Double
                m_Buffers(i - 1).Type = BUF_DOUBLE
                mi_NbTotBufferDouble = mi_NbTotBufferDouble + 1
            
                mi_NbBufferDouble = mi_NbBufferDouble + 1
                m_Buffers(i - 1).Position = mi_NbBufferDouble
                
            Case SQL_REAL ' VB Single
                m_Buffers(i - 1).Type = BUF_REAL
                mi_NbTotBufferReal = mi_NbTotBufferReal + 1
            
                mi_NbBufferReal = mi_NbBufferReal + 1
                m_Buffers(i - 1).Position = mi_NbBufferReal
                
            Case SQL_CHAR, SQL_VARCHAR ' VB String
                ' We use a common function to determine the real type of string value
                SelectTypeChar m_DescColumns(i - 1).SizeColumn, i
                    
            Case Else ' VB String
                ' In other case, we use a string type and call the common method to
                ' determine the best size
                SelectTypeChar m_DescColumns(i - 1).SizeColumn, i
                
        End Select
    Next

    Exit Sub
    
ErrorManager:
    ' There was an error, the method fails
    StdError

End Sub
Private Sub DeleteStatement()
'------------------------------------------------------------------
' Name : DeleteStatement
'
' Purpose : Destroy the statement
'
' Parameters : None
'
' review : 06/28/1999 by AD
'------------------------------------------------------------------

If mb_FreeStmt = KO Then
    If mb_Use_NCS_ODBC = True Then
        NCS_FreeStatement ml_Hstmt, SQL_DROP
    Else
        SQLFreeStatement ml_Hstmt, SQL_DROP
    End If
    mb_FreeStmt = OK
End If
       
End Sub


Private Sub InitializeGeneralBuffers()
'------------------------------------------------------------------
' Name : InitializeGeneralBuffers
'
' Purpose : Initialize the size of the general buffers in function
'           of the column number
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
    ' There must be a new buffer for the new column
    ReDim m_Buffers(mi_NbBuffer)
    ReDim m_NbData(mi_NbBuffer)
      
End Sub
Private Sub SelectTypeChar(l_Size As Long, l_column As Integer)
'------------------------------------------------------------------
' Name : SelectTypeChar
'
' Purpose : Select the best Buffer Type for string value or
'           unknown type
'
' Parameters : None
'
' review : 06/30/1999 by AD
'------------------------------------------------------------------
      
    Select Case l_Size
        Case Is <= 5
            m_Buffers(l_column - 1).Type = BUF_STRING5
            mi_NbTotBufferString5 = mi_NbTotBufferString5 + 1
                        
            mi_NbBufferString5 = mi_NbBufferString5 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString5
                       
        Case Is <= 20
            m_Buffers(l_column - 1).Type = BUF_STRING20
            mi_NbTotBufferString20 = mi_NbTotBufferString20 + 1
            
            mi_NbBufferString20 = mi_NbBufferString20 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString20
        
        Case Is <= 80
            m_Buffers(l_column - 1).Type = BUF_STRING80
            mi_NbTotBufferString80 = mi_NbTotBufferString80 + 1
                    
            mi_NbBufferString80 = mi_NbBufferString80 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString80
    
        Case Is <= 120
            m_Buffers(l_column - 1).Type = BUF_STRING120
            mi_NbTotBufferString120 = mi_NbTotBufferString120 + 1
                    
            mi_NbBufferString120 = mi_NbBufferString120 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString120
    
        Case Is <= 200
            m_Buffers(l_column - 1).Type = BUF_STRING200
            mi_NbTotBufferString200 = mi_NbTotBufferString200 + 1
                    
            mi_NbBufferString200 = mi_NbBufferString200 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString200
    
        Case Is <= 255
            m_Buffers(l_column - 1).Type = BUF_STRING255
            mi_NbTotBufferString255 = mi_NbTotBufferString255 + 1
            
            mi_NbBufferString255 = mi_NbBufferString255 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString255
    
        Case Is <= 500
            m_Buffers(l_column - 1).Type = BUF_STRING500
            mi_NbTotBufferString500 = mi_NbTotBufferString500 + 1
                        
            mi_NbBufferString500 = mi_NbBufferString500 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString500
    
        Case Is <= 1000
            m_Buffers(l_column - 1).Type = BUF_STRING1000
            mi_NbTotBufferString1000 = mi_NbTotBufferString1000 + 1
            
            mi_NbBufferString1000 = mi_NbBufferString1000 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString1000
        
        Case Else
            m_Buffers(l_column - 1).Type = BUF_STRING1000
            mi_NbTotBufferString1000 = mi_NbTotBufferString1000 + 1
        
            mi_NbBufferString1000 = mi_NbBufferString1000 + 1
            m_Buffers(l_column - 1).Position = mi_NbBufferString1000
    
        End Select

End Sub

Private Sub InitializeDataBuffers()
'------------------------------------------------------------------
' Name : InitializeDataBuffers
'
' Purpose : Initialize the size of the data buffers
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
      
    ' Initialize the size for the numeric buffers
    ReDim m_BufferInteger(mi_NbTotBufferInteger)
    ReDim m_BufferLong(mi_NbTotBufferLong)
    ReDim m_BufferReal(mi_NbTotBufferReal)
    ReDim m_BufferDouble(mi_NbTotBufferDouble)
       
    If mb_ExtendedFetch = OK Then
        ' We use the Extended Fetch method
        ReDim m_BufferStringB5(mi_NbTotBufferString5)
        ReDim m_BufferStringB20(mi_NbTotBufferString20)
        ReDim m_BufferStringB80(mi_NbTotBufferString80)
        ReDim m_BufferStringB120(mi_NbTotBufferString120)
        ReDim m_BufferStringB200(mi_NbTotBufferString200)
        ReDim m_BufferStringB255(mi_NbTotBufferString255)
        ReDim m_BufferStringB500(mi_NbTotBufferString500)
        ReDim m_BufferStringB1000(mi_NbTotBufferString1000)
    Else
        ' We use the classic method
        ReDim m_BufferString5(mi_NbTotBufferString5)
        ReDim m_BufferString20(mi_NbTotBufferString20)
        ReDim m_BufferString80(mi_NbTotBufferString80)
        ReDim m_BufferString120(mi_NbTotBufferString120)
        ReDim m_BufferString200(mi_NbTotBufferString200)
        ReDim m_BufferString255(mi_NbTotBufferString255)
        ReDim m_BufferString500(mi_NbTotBufferString500)
        ReDim m_BufferString1000(mi_NbTotBufferString1000)
    End If
    
End Sub

Public Function ExecuteQry(ls_Command As String, lb_Cursor As Boolean) As Boolean
'------------------------------------------------------------------
' Name : ExecuteQry
'
' Purpose : Execute the query and initialize variables
'
' Parameters :
'       ls_command          request to make at the database
'       lb_cursor           indicate if we can use multicursor (OK) or not (KO)
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Dim Resp As Boolean
    
    ' The method was'nt successfully by default
    ExecuteQry = KO

    mb_UseCache = KO

    'Verify if the Database and Environment identifier are correct
    If (ml_Database = 0 Or ml_Environment = 0) And mb_Use_NCS_ODBC = False Then
        Exit Function
    End If

    ' We use the Extended Fetch method by default
    mb_ExtendedFetch = OK

    ' If it exists, the statement must be closed before to execute a new query
    DeleteStatement

    ' Create the query with the Extended Fetch method
    If lb_Cursor = OK Then
        If mb_Use_NCS_ODBC = True Then
            Resp = NCS_ClassicSubmit(ml_Hstmt, ls_Command, OK, MULTIROW_FETCH, NB_MAX_DATA)
        Else
            Resp = SQLClassicSubmit(ml_Environment, ml_Database, ml_Hstmt, ls_Command, OK, MULTIROW_FETCH, NB_MAX_DATA)
        End If
    End If
    
    ' The Extended Fetch method fails, we create the query with the classic method
    If lb_Cursor = KO Or Resp = KO Then
        mb_ExtendedFetch = KO
        If mb_Use_NCS_ODBC = True Then
            Resp = NCS_ClassicSubmit(ml_Hstmt, ls_Command, KO)
        Else
            Resp = SQLClassicSubmit(ml_Environment, ml_Database, ml_Hstmt, ls_Command, KO)
        End If
    End If
    
    ' If one method is successefully, we can work
    If Resp = OK Then
        ' The statement is opened
        mb_FreeStmt = KO
        
        ' Read the columns number of the query
        SQLNumResultCols ml_Hstmt, mi_NbBuffer
        
        ' Initialize the general buffers
        InitializeGeneralBuffers
    
        ' Read the type of each column
        ReadColumnDescription
        
        ' Initialize each types buffers in function of each column
        InitializeDataBuffers
        
        If mb_ExtendedFetch = OK Then
            ' Initialize ODBC driver for each column
            ExecuteQry = BindCol
        Else
            ' With the standard method, the Fetch class is ready to read the data
            ExecuteQry = OK
        End If
    End If

End Function

Public Function GetData(li_Count As Integer, li_Col As Integer) As String
'------------------------------------------------------------------
' Name : GetData
'
' Purpose : Get the data stocked in the buffer.
'
' Parameters :
'       li_count        row of the record in the group
'       li_col          column of the record
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Dim li_Column As Integer
Dim li_size As Long

    ' There is no value by default
    GetData = ""
    
    ' Test the presence of data or if the row was correctly readed
    If mb_DataPresent = KO _
       Or li_Count < 1 _
       Or li_Count > NB_MAX_DATA _
       Or li_Col < 1 _
       Or li_Col > mi_NbBuffer _
       Or m_RowStatus(li_Count - 1) <> SQL_ROW_SUCCESS _
       Then Exit Function
   
    ' If the size is negativ, we can exit
    If m_NbData(li_Col - 1).Data(li_Count - 1) < 0 Then Exit Function
    
    ' Read the real position in the type buffers
    li_Column = m_Buffers(li_Col - 1).Position
    
    ' Read the size of the value
    li_size = m_NbData(li_Col - 1).Data(li_Count - 1)
    
    Select Case m_Buffers(li_Col - 1).Type
        Case BUF_INTEGER
            If li_size = 0 Then
                GetData = ""
            Else
                GetData = Formatage2(Str(m_BufferInteger(li_Column - 1).Data(li_Count - 1)))
            End If
            
        Case BUF_LONG
            If li_size = 0 Then
                GetData = ""
            Else
                GetData = Formatage2(Str(m_BufferLong(li_Column - 1).Data(li_Count - 1)))
            End If
                
        Case BUF_REAL
            If li_size = 0 Then
                GetData = ""
            Else
                GetData = Formatage2(Str(CDec(m_BufferReal(li_Column - 1).Data(li_Count - 1))))
            End If
        
        Case BUF_DOUBLE
            If li_size = 0 Then
                GetData = ""
            Else
                GetData = Formatage2(Str(CDec(m_BufferDouble(li_Column - 1).Data(li_Count - 1))))
            End If

        Case BUF_STRING5
            If li_size > 5 Then
                li_size = 5
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB5(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString5(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
            
        Case BUF_STRING20
            If li_size > 20 Then
                li_size = 20
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB20(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString20(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
                
        Case BUF_STRING80
            If li_size > 80 Then
                li_size = 80
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB80(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString80(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
                
        Case BUF_STRING120
            If li_size > 120 Then
                li_size = 120
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                  GetData = Trim$(Mid$(StrConv(m_BufferStringB120(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                  GetData = Trim$(Mid$(m_BufferString120(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
            
        Case BUF_STRING200
            If li_size > 200 Then
                li_size = 200
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB200(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString200(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
        
        Case BUF_STRING255
            If li_size > 255 Then
                li_size = 255
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB255(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString255(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
        
        Case BUF_STRING500
            If li_size > 500 Then
                li_size = 500
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB500(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString500(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
            
        Case BUF_STRING1000
            If li_size > 1000 Then
                li_size = 1000
            End If
            
            ' Choice the string buffer in function of method
            If mb_ExtendedFetch = OK Then
                GetData = Trim$(Mid$(StrConv(m_BufferStringB1000(li_Column - 1).Data(li_Count - 1).Value, vbUnicode), 1, li_size))
            Else
                GetData = Trim$(Mid$(m_BufferString1000(li_Column - 1).Data(li_Count - 1), 1, li_size))
            End If
        
    End Select
    
End Function

Public Function NbCol() As Integer
'------------------------------------------------------------------
' Name : NbCol
'
' Purpose : Return the columns number of the query.
'
' Parameters : None
'
' review : 06/28/1999 by AD
'------------------------------------------------------------------
    NbCol = mi_NbBuffer
    
End Function


Public Function RowCount() As Long
'------------------------------------------------------------------
' Name : RowCount
'
' Purpose : return the rows number in the table
'
' Parameters : None
'
' review : 06/25/1999 by AD
'------------------------------------------------------------------
Dim ll_count As Long

    RowCount = -1

    ' Test if the statement is not closed
    If mb_FreeStmt = OK Then Exit Function

    'Read the rows number
    If mb_Use_NCS_ODBC = True Then
        NCS_RowCount ml_Hstmt, ll_count
    Else
        SQLRowCount ml_Hstmt, ll_count
    End If
    
    RowCount = ll_count
End Function

Property Get MaxRowCount() As Long
'------------------------------------------------------------------
' Name : MaxRowCount
'
' Purpose : return the rows number max that Fetch read
'
' Parameters : None
'
' review : 07/13/1999 by AD
'------------------------------------------------------------------
    MaxRowCount = NB_MAX_DATA
End Property

Public Function FillMore() As Long
'------------------------------------------------------------------
' Name : FillMore
'
' Purpose : Read the NB_MAX_DATA next rows
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
Dim li_nbRows As Long
Dim li_Column As Long
Dim ls_value As String
Dim i As Integer
Dim li_return As Long

On Error GoTo ErrorManager

FillMore = 0

' Test if the statement is not closed
If mb_FreeStmt = OK Then Exit Function

' By default there is data in memory
mb_DataPresent = OK

' Choice the read method
If mb_ExtendedFetch = OK Then
    
    ' Use the Extended Fetch Method
    SQLExtendedFetch ml_Hstmt, SQL_FETCH_NEXT, NB_MAX_DATA, li_nbRows, m_RowStatus(0)
    
Else
    ' Use the classic method
    li_nbRows = 0
    
    If mb_Use_NCS_ODBC = True Then
        li_return = NCS_Fetch(ml_Hstmt)
    Else
        li_return = SQLFetch(ml_Hstmt)
    End If
    Do While li_nbRows < 25 And li_return = SQL_SUCCESS
        ' Read the next row
        li_nbRows = li_nbRows + 1
        
        ' Read all columns
        For i = 1 To mi_NbBuffer
            
            ' Read the real position in the type buffers
            li_Column = m_Buffers(i - 1).Position
            
            ' Read the value
            If mb_Use_NCS_ODBC = True Then
                ls_value = NCS_GetData(ml_Hstmt, i)
            Else
                ls_value = ODBCData(ml_Hstmt, i)
            End If
            
            ' Indicate the size of the value (used only for string value)
            m_NbData(i - 1).Data(li_nbRows - 1) = Len(ls_value)
            
            Select Case m_Buffers(i - 1).Type
                Case BUF_INTEGER
                    If ls_value = "" Then ls_value = "0"
                    m_BufferInteger(li_Column - 1).Data(li_nbRows - 1) = Val(ls_value)
                    
                Case BUF_LONG
                    If ls_value = "" Then ls_value = "0"
                    m_BufferLong(li_Column - 1).Data(li_nbRows - 1) = Val(ls_value)
                        
                Case BUF_REAL
                    If ls_value = "" Then ls_value = "0"
                    m_BufferReal(li_Column - 1).Data(li_nbRows - 1) = Val(ls_value)
                
                Case BUF_DOUBLE
                    If ls_value = "" Then ls_value = "0"
                    m_BufferDouble(li_Column - 1).Data(li_nbRows - 1) = Val(ls_value)
        
                Case BUF_STRING5
                    m_BufferString5(li_Column - 1).Data(li_nbRows - 1) = ls_value
                        
                Case BUF_STRING20
                    m_BufferString20(li_Column - 1).Data(li_nbRows - 1) = ls_value
                        
                Case BUF_STRING80
                    m_BufferString80(li_Column - 1).Data(li_nbRows - 1) = ls_value
                        
                Case BUF_STRING120
                    m_BufferString120(li_Column - 1).Data(li_nbRows - 1) = ls_value
                    
                Case BUF_STRING200
                    m_BufferString200(li_Column - 1).Data(li_nbRows - 1) = ls_value
                
                Case BUF_STRING255
                    m_BufferString255(li_Column - 1).Data(li_nbRows - 1) = ls_value
                
                Case BUF_STRING500
                    If mb_Use_NCS_ODBC = True Then
                         m_BufferString500(li_Column - 1).Data(li_nbRows - 1) = ls_value + NCS_GetMemo(ml_Hstmt, i - 1)
                    Else
                        m_BufferString500(li_Column - 1).Data(li_nbRows - 1) = ls_value + ODBCMemoGet(ml_Hstmt, i - 1)
                    End If
                    
                Case BUF_STRING1000
                    If mb_Use_NCS_ODBC = True Then
                        m_BufferString1000(li_Column - 1).Data(li_nbRows - 1) = ls_value + NCS_GetMemo(ml_Hstmt, i - 1)
                    Else
                        m_BufferString1000(li_Column - 1).Data(li_nbRows - 1) = ls_value + ODBCMemoGet(ml_Hstmt, i - 1)
                    End If
                
            End Select
        Next
        
        ' Indicate the status of the row
        m_RowStatus(li_nbRows) = SQL_ROW_SUCCESS
        
        ' Read the next row (not if it was the last)
        If li_nbRows < NB_MAX_DATA Then
            If mb_Use_NCS_ODBC = True Then
                li_return = NCS_Fetch(ml_Hstmt)
            Else
                li_return = SQLFetch(ml_Hstmt)
            End If
        End If
    Loop
    
    ' The other rows don't exist
    For i = li_nbRows + 1 To NB_MAX_DATA
        m_RowStatus(i) = SQL_ERROR
    Next
    
End If

If li_nbRows = 0 Then
    ' There is no data in memory
    mb_DataPresent = KO
End If

If li_nbRows < NB_MAX_DATA And mb_FreeStmt = KO Then
    ' The statement can be closed
    DeleteStatement
End If

' Return the number of rows in buffer
FillMore = li_nbRows

Exit Function

ErrorManager:
    ' The statement must be closed
    DeleteStatement
    ' There is no data present
    mb_DataPresent = KO
    ' 0 rows have been readed
    FillMore = 0
    StdError
End Function

Private Sub Class_Initialize()
'------------------------------------------------------------------
' Name : Initialize
'
' Purpose : Initialize the new instance of the class
'
' Parameters : None
'
' review : 06/28/1999 by AD
'------------------------------------------------------------------
    
    ' No buffer are used
    mi_NbBuffer = 0
    ' There is no statement
    mb_FreeStmt = OK
    ' There is no data
    mb_DataPresent = KO

    ml_Database = 0
    ml_Environment = 0
    
    mb_Use_NCS_ODBC = False
End Sub

Private Sub Class_Terminate()
'------------------------------------------------------------------
' Name : Terminate
'
' Purpose : Close the current instance of the class
'
' Parameters : None
'
' review : 09/01/1999 by AD
'------------------------------------------------------------------
    
    ' Delete the statement
    DeleteStatement
    
    ' Delete the buffer in memory
    ReDim m_BufferInteger(0)
    ReDim m_BufferLong(0)
    ReDim m_BufferReal(0)
    ReDim m_BufferDouble(0)
    
    ' Delete the string buffers of the Extended Fetch method
    ReDim m_BufferStringB5(0)
    ReDim m_BufferStringB20(0)
    ReDim m_BufferStringB80(0)
    ReDim m_BufferStringB120(0)
    ReDim m_BufferStringB200(0)
    ReDim m_BufferStringB255(0)
    ReDim m_BufferStringB500(0)
    ReDim m_BufferStringB1000(0)
    
    ' Delete the string buffers of the classic method
    ReDim m_BufferString5(0)
    ReDim m_BufferString20(0)
    ReDim m_BufferString80(0)
    ReDim m_BufferString120(0)
    ReDim m_BufferString200(0)
    ReDim m_BufferString255(0)
    ReDim m_BufferString500(0)
    ReDim m_BufferString1000(0)
    
    ' Delete the general buffer
    ReDim m_Buffers(0)
    ReDim m_NbData(0)

End Sub
